let _width = $(window).width();
let _height = $(window).height();
let width = 0.9 * _width;
let height = 0.96 * _height;

let x_attr = 'date';
let y_attr =  'close';
let fontFamily;
let categories;

function set_ui() {
    // 设置字体
    let ua = navigator.userAgent.toLowerCase();
    fontFamily = "Khand-Regular";
    if (/\(i[^;]+;( U;)? CPU.+Mac OS X/gi.test(ua)) {
        fontFamily = "PingFangSC-Regular";
    }
    d3.select("body")
        .style("font-family", fontFamily);
}

function Path(data, x, y) {
    let path = d3.path();
    let start = data[0];

    path.moveTo(x(str2date(start[x_attr])), y(start[y_attr]));
    for (let i = 1; i < data.length; i++) {
        let d = data[i];
        path.lineTo(x(str2date(d[x_attr])), y(d[y_attr]));
    }

    return path.toString();
}

function draw_main() {
    let padding = {'left': 0.2*width, 'bottom': 0.1*height, 'top': 0.2*height, 'right': 0.1*width};
    let svg = d3.select('#container')
        .select('svg')
        .attr('width', width)
        .attr('height', height);

    // title
    svg.append('g')
        .attr('transform', `translate(${padding.left+(width-padding.left-padding.right)/2}, ${padding.top*0.4})`)
        .append('text')
        .attr('class', 'title')
        .text('Line Chart for Daily Close of Apple Stock');

    // x axis - date
    let x = d3.scaleTime()
        .domain(get_min_max_date(data, x_attr))
        .range([padding.left, width-padding.right]);

    let axis_x = d3.axisBottom()
        .scale(x)
        .ticks(d3.timeMonth.every(3));

    // y axis - close
    let y = d3.scaleLinear()
        .domain([0, d3.max(data, d => d[y_attr])])
        .range([height-padding.bottom, padding.top]);    
    let axis_y = d3.axisLeft()
        .scale(y)
        .ticks(10)
        .tickFormat(d3.format('~s'));

    console.log('max price', d3.max(data, d => d[y_attr]));

    // x axis
    svg.append('g')
        .attr('transform', `translate(${0}, ${height-padding.bottom})`)
        .call(axis_x)
        .attr('font-family', fontFamily)
        .attr('font-size', '0.8rem')

    svg.append('g')
        .attr('transform', `translate(${padding.left+(width-padding.left-padding.right)/2}, ${height-padding.bottom})`)
        .append('text')
        .attr('class', 'axis_label')
        .attr('dx', '-0.4rem')
        .attr('dy', 0.08*height)
        .text(x_attr);

    // y axis
    svg.append('g')        
        .attr('transform', `translate(${padding.left}, ${0})`)
        .call(axis_y)
        .attr('font-family', fontFamily)
        .attr('font-size', '0.8rem')
    svg.append('g')
        .attr('transform', `
            translate(${padding.left}, ${height/2})
            rotate(-90)    
        `)
        .append('text')
        .attr('class', 'axis_label')
        .attr('dy', -height*0.07)
        .text(y_attr);

    // line
    svg.append('g')
        .append('path')
        .datum(data)
        .attr('class', 'line')
        .attr('d', d => Path(d, x, y));
}

function main() {
    d3.csv(data_file).then(function(DATA) {
        data = DATA;
        data.forEach(d => {
            d[y_attr] = parseFloat(d[y_attr]);
        })
        console.log('data', data);
        
        set_ui();
        draw_main();
    })
}

main()